#ifndef NASCCL_MATH_H
#define NASCCL_MATH_H
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    The NASCCL mathematic primitives...
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// SwapBytes. Return The Calculated Values.
#define SwapBytes(x, y) x ^= y ^= x ^= y

// XOR "Value1" And "Value2". Return The Calculated Result.
#define Round1(Value1, Value2)  ( (Value1) ^  (Value2) )

// IOR "Value1" And "Value2". Return The Calculated Result.
#define Round2(Value1, Value2)  ( (Value1) |  (Value2) )

// RHS "Value1" And "Value2". Return The Calculated Result.
#define Round3(Value1, Value2)  ( (Value2) << (Value1) )

// XAND "Value1" And "Value2". Return The Calculated Result.
#define Round4(Value1, Value2)  ( (Value1) &  (Value2) )

// LHS "Value1" And "Value2". Return The Calculated Result.
#define Round5(Value1, Value2)  ( (Value1) << (Value2) )

// Multiply "Value1" And "Value2". Return The Calculated Result.
#define Round6(Value1, Value2)  ( (Value1) *  (Value2) )

// Round Bytes. Return The Calculated Result.
#define RoundBytes(xInput1, xInput2, xXOR)  (( xInput1 + xInput2 ) ^ xXOR)

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

